::--------------------------------------------------------------------------------
::                        HIT - Windows Zabbix Agent v4.4.5
::--------------------------------------------------------------------------------
@echo off
:: Alterar os valores "SUBSTITUIR" pelo IP do Proxy e o Codigo da Organizacao, respectivamente:
set IP_Proxy=SUBSTITUIR
set Nome_Organizacao=SUBSTITUIR
::
::
:: Nao alterar as linhas abaixo

call :GetInfo
call :ConfirmarHostname
call :CheckFolder

if %MENU_OPTION%==0 (
	call :NormalInstall
) else if %MENU_OPTION%==1 (
	call :UninstallAgent
) else if %MENU_OPTION%==2 (
	call :InstallMultipleAgent
) else if %MENU_OPTION%==3 (
	call :Cancel
)
pause

:GetInfo
	if %IP_Proxy%==SUBSTITUIR (
		set /p IP_Proxy="Digite o IP do Proxy: "
	)
	if %Nome_Organizacao%==SUBSTITUIR (
		set /p Nome_Organizacao="Digite o codigo da organizacao: "
	)
EXIT /B 0

:ConfirmarHostname
	set /p Host_Name="O nome do host sera %COMPUTERNAME%. Continuar?(s/n): "
	if %Host_Name%==s (
		set Host_Name=%COMPUTERNAME%
	) else if %Host_Name%==n (
		set /p Host_Name="Digite o nome do Host: "
	) else (
	call :ConfirmarHostname
	)
EXIT /B 0

:CheckFolder
	set MENU_OPTION=0
	if exist "C:\Zabbix" (
		echo "Ja existe uma instalacao do servico Zabbix."
		echo "1 - Remover servico atual e reinstalar"
		echo "2 - Instalar um segundo Agent"
		echo "3 - Cancelar instalacao"
		set /p MENU_OPTION="Escolha uma opcao: "
	)
EXIT /B 0

:UninstallAgent
	"C:\Zabbix\zabbix_agentd.exe" --stop
	"C:\Zabbix\zabbix_agentd.exe" --uninstall
	del /s /q "C:\Zabbix"
	echo Servico Zabbix removido

	call :NormalInstall
EXIT /B 0

:NormalInstall
	echo Copiando os arquivos de instalacao...

	mkdir C:\Zabbix

	set isX64=False && if /I "%PROCESSOR_ARCHITECTURE%"=="AMD64" ( set isX64=True ) else ( if /I "%PROCESSOR_ARCHITEW6432%"=="AMD64" ( set isX64=True ) )

	if %isX64%==True (
		xcopy "%~dp0bin\win64\zabbix_agentd.exe" c:\Zabbix
		xcopy "%~dp0bin\win64\zabbix_get.exe" c:\Zabbix
		xcopy "%~dp0bin\win64\zabbix_sender.exe" c:\Zabbix
	) else (
		xcopy "%~dp0bin\win32\zabbix_agentd.exe" c\Zabbix
		xcopy "%~dp0bin\win32\zabbix_get.exe" c:\Zabbix
		xcopy "%~dp0bin\win32\zabbix_sender.exe" c:\Zabbix
	)

	echo Criando arquivos de configuracao...

	echo Server=%IP_Proxy% > C:\Zabbix\zabbix_agentd.conf
	echo ServerActive=%IP_Proxy% >> C:\Zabbix\zabbix_agentd.conf
	echo Timeout=30 >> C:\Zabbix\zabbix_agentd.conf
	echo Hostname=%Host_Name%_%Nome_Organizacao% >> C:\Zabbix\zabbix_agentd.conf
	echo StartAgents=5 >> C:\Zabbix\zabbix_agentd.conf
	echo DebugLevel=3 >> C:\Zabbix\zabbix_agentd.conf
	echo LogFile=C:\Zabbix\zabbix_agentd.log >> C:\Zabbix\zabbix_agentd.conf
	echo EnableRemoteCommands=1 >> C:\Zabbix\zabbix_agentd.conf
	echo ListenPort=10050 >> C:\Zabbix\zabbix_agentd.conf

	echo Instalando o Servico do Zabbix...

	C:\Zabbix\zabbix_agentd.exe -i -c C:\Zabbix\zabbix_agentd.conf
	C:\Zabbix\zabbix_agentd.exe -s -c C:\Zabbix\zabbix_agentd.conf

	echo Criando a regra de Firewall...

	netsh advfirewall firewall add rule name="Zabbix Agent Monitor" dir=in action=allow protocol=TCP localport=10050

	echo Instalacao concluida
EXIT /B 0

:InstallMultipleAgent
	echo Copiando os arquivos de instalacao...

	mkdir C:\AgentHIT

	set isX64=False && if /I "%PROCESSOR_ARCHITECTURE%"=="AMD64" ( set isX64=True ) else ( if /I "%PROCESSOR_ARCHITEW6432%"=="AMD64" ( set isX64=True ) )

	if %isX64%==True (
		xcopy "%~dp0bin\win64\zabbix_agentd.exe" c:\AgentHIT
		xcopy "%~dp0bin\win64\zabbix_get.exe" c:\AgentHIT
		xcopy "%~dp0bin\win64\zabbix_sender.exe" c:\AgentHIT
	) else (
		xcopy "%~dp0bin\win32\zabbix_agentd.exe" c:\AgentHIT
		xcopy "%~dp0bin\win32\zabbix_get.exe" c:\AgentHIT
		xcopy "%~dp0bin\win32\zabbix_sender.exe" c:\AgentHIT
	)

	echo Criando arquivos de configuracao...

	echo Server=%IP_Proxy% > C:\AgentHIT\zabbix_agentd.conf
	echo ServerActive=%IP_Proxy% >> C:\AgentHIT\zabbix_agentd.conf
	echo Timeout=30 >> C:\AgentHIT\zabbix_agentd.conf
	echo Hostname=%Host_Name%_%Nome_Organizacao% >> C:\AgentHIT\zabbix_agentd.conf
	echo StartAgents=5 >> C:\AgentHIT\zabbix_agentd.conf
	echo DebugLevel=3 >> C:\AgentHIT\zabbix_agentd.conf
	echo LogFile=C:\AgentHIT\zabbix_agentd.log >> C:\AgentHIT\zabbix_agentd.conf
	echo EnableRemoteCommands=1 >> C:\AgentHIT\zabbix_agentd.conf
	echo ListenPort=10052 >> C:\AgentHIT\zabbix_agentd.conf


	echo Instalando o Servico do Zabbix...

	C:\AgentHIT\zabbix_agentd.exe --config C:\AgentHIT\zabbix_agentd.conf --install --multiple-agents
	C:\AgentHIT\zabbix_agentd.exe --config C:\AgentHIT\zabbix_agentd.conf --start --multiple-agents


	echo Criando a regra de Firewall...

	netsh advfirewall firewall add rule name="HIT Zabbix Agent Monitor" dir=in action=allow protocol=TCP localport=10052

	echo Instalacao de multiplo agente concluida
EXIT /B 0

:Cancel
	echo Instalacao cancelada
EXIT /B 0

